﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int tdscdmaTest()
        {
            // Configure variables for WCDMA Standard
            string testWaveform = tdscdmaArb;
            string testName = "TD-SCDMA Test";
            vsag.setupParameters("TD-SCDMA");
            dataLog.tstName = "TD-SCDMA";

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // For TDD waveforms, external triggering must be used to make sure measurements are made during the RF burst
            bool useExtTrig = true;

            // Configure for External Trigger on Falling Edge of ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL", 1e-3);


            if (testEvm)
            {
                // Setup the VSG and VSA for waveform, band frequency and power level
                // If we are measuring EVM, need to use the complete waveform
                //Lib.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain);
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true, 5e-3);
            }
            else
            {
                // Setup the VSG and VSA for waveform, band frequency and power level
                // If we are not measuing EVM, and to keep the same duty cycle, use the first sub frame only (5 ms)
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true, 5e-3);
            }


            // Configure the EVM measurement
            if (testEvm)
                vsag.configTdscdmaEvmMeas("MS", cellFreqs[0], targetPout);

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");
                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testAcpr)
                {
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measFftAcpr();
                    else
                        vsag.measStdAcpr();
                }

                if (testEvm)
                {
                    // Measure EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measTdscdmaEvm();
                    vsag.lockVsa();
                    
                    if (useExtTrig)
                    {
                        // Configure for External Trigger on ARB Wrap signal
                        vsag.configVsaTrigger("EXTERNAL", 1e-3);
                    }
                    vsag.setupVsa(cellFreqs[i], targetPout);
                }

                if (testHarms)
                {
                    // Measure Harmonics using Spectrum Method
                    vsag.measSpecHarms(true, true);
                    //Lib.measSpecHarms2(new bool[] { true, true, true, true, true, true });
                    //Lib.measPwrHarms2(new bool[] { true, true, true, true, true, true });
                }

                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Put it back to immediate trigger
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}